﻿﻿@echo off

REM ===========================================
REM   Open62541 Build Script – Version 1.4.14 
REM   deterministisch, VS2022, Release-only
REM ===========================================

REM === Konfiguration ===
set REPO_URL=https://github.com/open62541/open62541.git
set REPO_DIR=open62541
set BUILD_DIR=build
set VS_GENERATOR=Visual Studio 17 2022
set OPEN62541_VERSION=v1.4.14

REM === CMake Flags für vollständige DLL ===
set CMAKE_FLAGS= ^
  -DBUILD_SHARED_LIBS=ON ^
  -DUA_ENABLE_HIGHPROFILE=ON ^
  -DUA_ENABLE_SUBSCRIPTIONS=ON ^
  -DUA_ENABLE_METHODCALLS=ON ^
  -DUA_ENABLE_NODEMANAGEMENT=ON ^
  -DUA_ENABLE_DISCOVERY=ON ^
  -DUA_ENABLE_HISTORIZING=ON ^
  -DUA_NAMESPACE_ZERO=FULL ^
  -DUA_ENABLE_ENCRYPTION=OFF ^
  -DUA_BUILD_EXAMPLES=OFF ^
  -DUA_BUILD_TOOLS=OFF ^
  -DUA_ENABLE_HARDENING:BOOL=ON ^
  -DUA_LOGLEVEL=500 ^
  -DUA_MULTITHREADING=100 ^
  -DCMAKE_BUILD_TYPE=Release ^

echo.
echo ============================================
echo   Open62541 Build Script – Version %OPEN62541_VERSION%
echo ============================================
echo.

REM ============================================================
REM   Laufende Compiler-/Build-Prozesse prüfen
REM ============================================================
echo [INFO] Pruefe auf laufende Compiler-Prozesse...
tasklist /FI "IMAGENAME eq cl.exe" | find /I "cl.exe" >nul 2>nul
if %errorlevel%==0 (
    echo [FEHLER] Es laufen noch cl.exe-Prozesse. Bitte Build/VS beenden und Skript erneut starten.
    goto end
)

REM ============================================================
REM   Blockierende Prozesse beenden
REM ============================================================
echo [INFO] Beende mögliche Build-/CMake-Prozesse...
taskkill /IM cmake.exe /F >nul 2>nul
taskkill /IM cmake-gui.exe /F >nul 2>nul
taskkill /IM ninja.exe /F >nul 2>nul
taskkill /IM MSBuild.exe /F >nul 2>nul
taskkill /IM cl.exe /F >nul 2>nul

REM ============================================================
REM   Prüfe ob CMake verfügbar ist
REM ============================================================
where cmake >nul 2>nul
if errorlevel 1 (
    echo [FEHLER] CMake ist nicht installiert oder nicht im PATH.
    goto end
)

REM ============================================================
REM   Prüfe ob Git verfügbar ist
REM ============================================================
where git >nul 2>nul
if errorlevel 1 (
    echo [FEHLER] Git ist nicht installiert oder nicht im PATH.
    goto end
)

REM ============================================================
REM   Repository klonen oder aktualisieren
REM ============================================================
if not exist %REPO_DIR% (
    echo [INFO] Klone open62541 Repository...
    git clone %REPO_URL%
    cd %REPO_DIR%
    git checkout %OPEN62541_VERSION%
    cd ..
) else (
    echo [INFO] Aktualisiere bestehendes Repository...
    cd %REPO_DIR%
    git fetch --all
    git checkout %OPEN62541_VERSION%
    cd ..
)

cd %REPO_DIR%
git fetch --all
git checkout %OPEN62541_VERSION%
git submodule update --init --recursive
cd ..

REM ============================================================
REM   Build-Ordner entfernen
REM ============================================================
echo [INFO] Entferne alte Build-Ordner...

if exist %BUILD_DIR%_x64 rmdir /s /q %BUILD_DIR%_x64
if exist %BUILD_DIR%_Win32 rmdir /s /q %BUILD_DIR%_Win32

REM ============================================================
REM   64-Bit Build
REM ============================================================
echo.
echo [INFO] Erzeuge 64-Bit DLL...

mkdir %BUILD_DIR%_x64
cd %BUILD_DIR%_x64

cmake ../%REPO_DIR% -G "%VS_GENERATOR%" -A x64 %CMAKE_FLAGS%
cmake --build . --config Release

cd ..

REM ============================================================
REM   32-Bit Build
REM ============================================================
echo.
echo [INFO] Erzeuge 32-Bit DLL...

mkdir %BUILD_DIR%_Win32
cd %BUILD_DIR%_Win32

cmake ../%REPO_DIR% -G "%VS_GENERATOR%" -A Win32 %CMAKE_FLAGS%
cmake --build . --config Release

cd ..

REM ============================================================
REM   Fertig
REM ============================================================
echo.
echo ============================================
echo   [FERTIG] DLLs wurden erfolgreich erstellt.
echo ============================================
echo.
echo   64-Bit Ausgabe:   %BUILD_DIR%_x64\bin\Release\
echo   32-Bit Ausgabe:   %BUILD_DIR%_Win32\bin\Release\
echo.

:end
pause
endlocal